<?php 
	class Hallazgos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(3);
		}

		public function Hallazgos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Hallazgos";
			$data['page_title'] = "HALLAZGOS <small>E-Hallazgos</small>";
			$data['page_name'] = "hallazgos";
			$data['page_functions_js'] = "functions_hallazgos.js";
			$this->views->getView($this,"hallazgos",$data);
		}


		public function hallazgo()
		{
			echo $_SESSION['permisosMod']['r'];
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Hallazgo";
			$data['page_title'] = "EDITAR HALLAZGO <small>E-Hallazgos</small>";
			$data['page_name'] = "hallazgo";
			$data['page_functions_js'] = "functions_hallazgos.js";
			$this->views->getView($this,"hallazgo",$data);
		}

		public function getHallazgos()
		{			
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectHallazgos();				
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['id_estado_hallazgo'] == 1)
					{
						$arrData[$i]['id_estado_hallazgo'] = '<span class="badge badge-success">Cerrado</span>';
					}
					else
					{
						if($arrData[$i]['id_estado_hallazgo'] == 2)
						{
							$arrData[$i]['id_estado_hallazgo'] = '<span class="badge badge-success">Nulo</span>';
						}
						else
						{
							$arrData[$i]['id_estado_hallazgo'] = '<span class="badge badge-danger">Abierto</span>';
						}
					}

					$arrData[$i]['fecha'] = substr($arrData[$i]['fecha'],6,2)."-".substr($arrData[$i]['fecha'],4,2)."-".substr($arrData[$i]['fecha'],0,4);
				
					if ($arrData[$i]['fecha_cierre'])
						$arrData[$i]['fecha_cierre'] = substr($arrData[$i]['fecha_cierre'],6,2)."-".substr($arrData[$i]['fecha_cierre'],4,2)."-".substr($arrData[$i]['fecha_cierre'],0,4)." " .substr($arrData[$i]['fecha_cierre'],8,2).":".substr($arrData[$i]['fecha_cierre'],10,2);
					else
						$arrData[$i]['fecha_cierre'] = "";
					$arrData[$i]['nombrecompletoreporta'] = $arrData[$i]['nombrereporta']. " " .$arrData[$i]['apellidoreporta'] ;

					if($_SESSION['permisosMod']['u']){						
						$btnEdit = '<button class="btn btn-primary  btn-sm" onClick="fntEditInfo(this,'.$arrData[$i]['id_hallazgo'].')" title="Editar hallazgo"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){	
						$btnDelete = '<button class="btn btn-danger btn-sm" onClick="fntDelInfo('.$arrData[$i]['id_hallazgo'].')" title="Eliminar hallazgo"><i class="far fa-trash-alt"></i></button>';
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function setHallazgo(){			
			if($_POST){
				if(empty($_POST['listLugarHallazgo']) || empty($_POST['listAreaHallazgo']) || empty($_POST['listColaboradorHallazgo']) || empty($_POST['listFuenteHallazgo'])  || empty($_POST['listAmbitoHallazgo']) || empty($_POST['listTipoHallazgo']) || empty($_POST['txtDescripcionHallazgo']) || empty($_POST['txtAccionInmediataHallazgo']) || empty($_POST['txtCausaRaizHallazgo']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos o faltantes111.');
				}else{					

					 $intIdHallazgo = intval($_POST['idHallazgo']);			 
					 $strFecha = str_replace("-", "", strClean($_POST['FechaActual']));;
					 $intIdLugarHallazgo = intval($_POST['listLugarHallazgo']);					 
					 $intIdAreaHallazgo = strClean($_POST['listAreaHallazgo']);
					 $intIdempleado = intval($_POST['listColaboradorHallazgo']);					 					 
					 $intIdFuenteHallazgo = intval($_POST['listFuenteHallazgo']);
					 $intIdAmbitoHallazgo = intval($_POST['listAmbitoHallazgo']);
					 $intIdTipoHallazgo = intval($_POST['listTipoHallazgo']); 
					 $strDescripcion = strClean($_POST['txtDescripcionHallazgo']);		 
					 $strAccionInmediataHallazgo = strClean($_POST['txtAccionInmediataHallazgo']);
					 $strCausaRaizHallazgo = strClean($_POST['txtCausaRaizHallazgo']);
					 $strComentario = strClean($_POST['txtComentarioHallazgo']);
					 $intIdResponsableAnalisisCausal = intval($_POST['txtResponsableAnalisisCausal']);										 
					 $intFlash = $_POST['chkFlash'].checked;
											
					if ($intFlash)
						$intFlash = 1;
					else
						$intFlash = 0;
					
				dep($intFlash);
					$request_hallazgo = "";
					
					if($intIdHallazgo == 0)
					{
						$option = 1;
						if($_SESSION['permisosMod']['w']){
							$request_hallazgo = $this->model->insertHallazgo($strFecha,
																				$intIdLugarHallazgo,
																			 	$intIdAreaHallazgo,
																			 	$intIdempleado,	
																			 	$intIdFuenteHallazgo,
																			 	$intIdAmbitoHallazgo,
																			 	$intIdTipoHallazgo,
																			 	$strDescripcion,
																			 	$strAccionInmediataHallazgo,
																			 	$strCausaRaizHallazgo,
																			 	$strComentario,
					 															$intIdResponsableAnalisisCausal,
					 															$intFlash);
						}
					}else{
						$intEvaluacionEficacia = intval($_POST['EvaluacionEficacia']);					 					 					 
					 	$strObservacionSeguimiento = strClean($_POST['txtObservacionSeguimiento']);		
					 	$intIdEstadoHallazgo = intval($_POST['IdEstadoHallazgo']);
					 	$intEvaluacionEficacia = intval($_POST['EvaluacionEficacia']);
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_hallazgo = $this->model->updateHallazgo(	$intIdhallazgo,
																			 	$strFecha,
																				$intIdLugarHallazgo.
																			 	$intIdAreaHallazgo,
																			 	$intIdempleado,	
																			 	$intIdFuenteHallazgo,
																			 	$intIdAmbitoHallazgo,
																			 	$intIdTipoHallazgo,
																			 	$strDescripcion,
																			 	$strAccionInmediataHallazgo,
																			 	$strCausaRaizHallazgo,
																			 	$strComentario,
					 															$intIdResponsableAnalisisCausal,
					 															$intFlash,
																				$intEvaluacionEficacia,			 
																				$strObservacionSeguimiento,																				
																				$intIdEstadoHallazgo,
																				$intEvaluacionEficacia);
						}
					}

					if($request_hallazgo > 0 )
					{
						if($option == 1){
							$request_image = $this->model->updateImage($request_hallazgo);
							$arrResponse = array('status' => true, 'idhallazgo' => $request_hallazgo, 'msg' => 'Hallazgo generado exitosamente con el folio '.$request_hallazgo);
						}else{
							$arrResponse = array('status' => true, 'idhallazgo' => $idHallazgo, 'msg' => 'Datos Actualizados correctamente.');
						}
					}
					else 
					{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');					
					}
				}
				
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getHallazgo($idhallazgo){
			if($_SESSION['permisosMod']['r']){
				$idhallazgo = intval($idhallazgo);
				if($idhallazgo > 0){
					$arrData = $this->model->selectHallazgo($idhallazgo);

					if(empty($arrData)){
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrImg = $this->model->selectImages($idhallazgo);
						if(count($arrImg) > 0){
							for ($i=0; $i < count($arrImg); $i++) { 
								$arrImg[$i]['url_image'] = media().'/images/uploads/'.$arrImg[$i]['img'];
							}
						}
						$arrData['images'] = $arrImg;
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function setImage(){
			if($_POST){
				if(empty($_POST['idHallazgo']))
					$idHallazgo = $_SESSION['idUser'];				
				else
					$idHallazgo = intval($_POST['idHallazgo']);

					$foto      = $_FILES['foto'];
					$imgNombre = 'pro_'.md5(date('d-m-Y H:i:s')).'.jpg';
					$request_image = $this->model->insertImage($idHallazgo,$imgNombre);
					if($request_image){
						$uploadImage = uploadImage($foto,$imgNombre);
						$arrResponse = array('status' => true, 'imgname' => $imgNombre, 'msg' => 'Archivo cargado.');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error de carga.');
					}
				
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function delFile(){
			if($_POST){
				if(empty($_POST['file'])){
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					if (empty($_POST['idhallazgo']))
						$idHallazgo = 1;
					else						
						$idHallazgo = intval($_POST['idhallazgo']);
				//Eliminar de la DB
					$imgNombre  = strClean($_POST['file']);
					$request_image = $this->model->deleteImage($idHallazgo,$imgNombre);

					if($request_image){
						$deleteFile =  deleteFile($imgNombre);
						$arrResponse = array('status' => true, 'msg' => 'Archivo eliminado');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function delHallazgo(){
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdhallazgo = intval($_POST['idHallazgo']);
					$requestDelete = $this->model->deleteProducto($intIdhallazgo);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado el hallazgo');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el hallazgo');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}

 ?>