<?php 

	class Ambitos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function Ambitos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Ambitos";
			$data['page_title'] = "ÁMBITOS <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "ambitos";
			$data['page_functions_js'] = "functions_ambitos.js";
			$this->views->getView($this,"ambitos",$data);
		}

		public function setAmbito()
		{
			if($_POST)
			{			
				if(empty($_POST['txtNombre']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdambito = ucwords(strClean($_POST['idAmbito']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					
					$request_ambito = "";		
					if($intIdambito == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_ambito = $this->model->insertAmbito($strNombre);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_ambito = $this->model->updateAmbito($intIdambito,$strNombre);
						}

					}
				}

				if($request_ambito > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_ambito == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el ámbito ya existe, ingrese otro.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAmbitos()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectAmbitos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
//					if($_SESSION['permisosMod']['r']){
//						$btnView = '<button class="btn btn-info btn-sm btnViewAmbito" onClick="fntViewAmbito('.$arrData[$i]['id_ambito_hallazgo'].')" title="Ver ámbito"><i class="far fa-eye"></i></button>';
//					}

					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditAmbito" onClick="fntEditAmbito(this,'.$arrData[$i]['id_ambito_hallazgo'].')" title="Editar ámbito"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_ambito_hallazgo'];
							$parametro2 = "'".$arrData[$i]['nombre']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelAmbito" 
							onClick="fntDelAmbito('.$parametro1.",".$parametro2.')" title="Eliminar ámbito"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectAmbitos()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectAmbitos();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_ambito_hallazgo'].'">'.$arrData[$i]['nombre'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}

		public function getAmbito($idambito){
			if($_SESSION['permisosMod']['r']){
				$idambito = intval($idambito);
				if($idambito > 0)
				{
					$arrData = $this->model->selectAmbito($idambito);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delAmbito()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdAmbitoHallazgo = intval($_POST['idAmbito']);

					$requestDelete = $this->model->deleteAmbito($intIdAmbitoHallazgo);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Ámbito eliminado exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el ámbito.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function perfil(){
			$data['page_tag'] = "Perfil";
			$data['page_title'] = "Perfil de usuario";
			$data['page_name'] = "perfil";
			$data['page_functions_js'] = "functions_usuarios.js";
			$this->views->getView($this,"perfil",$data);
		}

		public function putPerfil(){
			if($_POST){
				if(empty($_POST['txtIdentificacion']) || empty($_POST['txtNombre']) || empty($_POST['txtApellido']) || empty($_POST['txtTelefono']) )
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idUsuario = $_SESSION['idUser'];
					$strIdentificacion = strClean($_POST['txtIdentificacion']);
					$strNombre = strClean($_POST['txtNombre']);
					$strApellido = strClean($_POST['txtApellido']);
					$intTelefono = intval(strClean($_POST['txtTelefono']));
					$strPassword = "";
					if(!empty($_POST['txtPassword'])){
						$strPassword = hash("SHA256",$_POST['txtPassword']);
					}
					$request_user = $this->model->updatePerfil($idUsuario,
																$strIdentificacion, 
																$strNombre,
																$strApellido, 
																$intTelefono, 
																$strPassword);
					if($request_user)
					{
						sessionUser($_SESSION['idUser']);
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible actualizar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function putDFical(){
			if($_POST){
				if(empty($_POST['txtNit']) || empty($_POST['txtNombreFiscal']) || empty($_POST['txtDirFiscal']) )
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idUsuario = $_SESSION['idUser'];
					$strNit = strClean($_POST['txtNit']);
					$strNomFiscal = strClean($_POST['txtNombreFiscal']);
					$strDirFiscal = strClean($_POST['txtDirFiscal']);
					$request_datafiscal = $this->model->updateDataFiscal($idUsuario,
																		$strNit,
																		$strNomFiscal, 
																		$strDirFiscal);
					if($request_datafiscal)
					{
						sessionUser($_SESSION['idUser']);
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible actualizar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

	}
 ?>